/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.level.ColorResolver;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeBlendCalculator;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.MapBiomeColorResolverDetector;

public class BlockStateColorTypeCache {
    public final BiomeKey PLACEHOLDER_BIOME;
    public final BiomeKey UNKNOWN_BIOME;
    private Hashtable<BlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<BlockState, ColorResolver> colorResolvers = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private BlockState grassState;
    private BlockState oakLeavesState;
    private BlockState waterState;
    private BiomeKeyManager biomeKeyManager;
    private ColorResolver DEFAULT_GRASS_RESOLVER;
    private ColorResolver DEFAULT_FOLIAGE_RESOLVER;
    private ColorResolver DEFAULT_WATER_RESOLVER;
    private MapBiomeColorResolverDetector colorResolverDetector;
    private BiomeBlendCalculator biomeBlendCalculator;

    public BlockStateColorTypeCache(BiomeKeyManager biomeKeyManager) {
        this.biomeKeyManager = biomeKeyManager;
        this.grassState = Blocks.field_196658_i.func_176223_P();
        this.oakLeavesState = Blocks.field_196642_W.func_176223_P();
        this.waterState = Blocks.field_150355_j.func_176223_P();
        this.UNKNOWN_BIOME = biomeKeyManager.get("xaeroworldmap:unknown_biome");
        this.PLACEHOLDER_BIOME = biomeKeyManager.get("xaeroworldmap:placeholder_biome");
        this.colorResolverDetector = new MapBiomeColorResolverDetector();
        this.biomeBlendCalculator = new BiomeBlendCalculator();
    }

    public BiomeKey getBlockBiomeColour(World world, BlockState state, BlockPos pos, int[] dest, BiomeKey biomeId, MutableRegistry<Biome> biomeRegistry) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        BiomeKey blockBiome = null;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_213162_bc();
        if (colorType == -1 && isRenderThread) {
            ColorResolver detectedColorResolver = this.colorResolverDetector.detectColorResolver(state, (IBlockDisplayReader)world, pos);
            if (detectedColorResolver == null) {
                if (state.func_177230_c() == Blocks.field_150355_j) {
                    detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                } else {
                    try {
                        customColour = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
                    }
                    catch (Throwable t) {
                        customColour = 0;
                    }
                    if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor) {
                        Material material = state.func_185904_a();
                        if (material != null && (material.func_151565_r() == MaterialColor.field_151661_c || material.func_151565_r() == MaterialColor.field_151669_i || material.func_151565_r() == MaterialColor.field_151662_n)) {
                            customColour = this.tryGettingColor(state, world, pos, 0);
                            gotFullCC = true;
                            if (material.func_151565_r() == MaterialColor.field_151661_c && customColour == this.tryGettingColor(this.grassState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                            } else if (material.func_151565_r() == MaterialColor.field_151669_i && customColour == this.tryGettingColor(this.oakLeavesState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                            } else if (material.func_151565_r() == MaterialColor.field_151662_n && customColour == this.tryGettingColor(this.waterState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                            }
                        }
                    } else if (customColour == this.grassColor) {
                        detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                    } else if (customColour == this.foliageColor) {
                        detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                    }
                }
            }
            if (detectedColorResolver != null) {
                colorType = 1;
                if (detectedColorResolver == this.DEFAULT_FOLIAGE_RESOLVER) {
                    colorType = 2;
                }
                this.colorResolvers.put(state, detectedColorResolver);
            } else {
                if (!gotFullCC) {
                    customColour = this.tryGettingColor(state, world, pos, 0);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == null) {
            if (isRenderThread) {
                biomeId = this.getBiome(world, pos, biomeRegistry);
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            blockBiome = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            blockBiome = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = this.tryGettingColor(state, world, pos, 0);
            }
            dest[2] = customColour;
        }
        return blockBiome;
    }

    public void updateGrassColor() {
        this.grassColor = this.tryGettingColor(this.grassState, null, null, 0);
        this.foliageColor = this.tryGettingColor(this.oakLeavesState, null, null, 0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }

    public void updateDefaultResolvers(World world) {
        if (world == null) {
            return;
        }
        this.DEFAULT_GRASS_RESOLVER = this.colorResolverDetector.detectColorResolver(Blocks.field_150349_c.func_176223_P(), (IBlockDisplayReader)world, new BlockPos(0, 0, 0));
        if (this.DEFAULT_GRASS_RESOLVER == null) {
            this.DEFAULT_GRASS_RESOLVER = BiomeColors.field_180291_a;
        }
        this.DEFAULT_FOLIAGE_RESOLVER = this.colorResolverDetector.detectColorResolver(Blocks.field_196642_W.func_176223_P(), (IBlockDisplayReader)world, new BlockPos(0, 0, 0));
        if (this.DEFAULT_FOLIAGE_RESOLVER == null) {
            this.DEFAULT_FOLIAGE_RESOLVER = BiomeColors.field_180289_b;
        }
        this.DEFAULT_WATER_RESOLVER = this.colorResolverDetector.detectColorResolver(Blocks.field_150355_j.func_176223_P(), (IBlockDisplayReader)world, new BlockPos(0, 0, 0));
        if (this.DEFAULT_WATER_RESOLVER == null) {
            this.DEFAULT_WATER_RESOLVER = BiomeColors.field_180290_c;
        }
    }

    private BiomeKey getBiome(World world, BlockPos pos, MutableRegistry<Biome> biomeRegistry) {
        Biome biome = world.func_226691_t_(pos);
        ResourceLocation biomeIdentifier = biomeRegistry.func_177774_c((Object)biome);
        return biomeIdentifier == null ? this.UNKNOWN_BIOME : this.biomeKeyManager.get(biomeIdentifier.toString());
    }

    private int tryGettingColor(BlockState state, World world, BlockPos pos, int tint) {
        this.biomeBlendCalculator.setWorld(world);
        try {
            return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (IBlockDisplayReader)(world == null ? null : this.biomeBlendCalculator), pos, tint);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    public ColorResolver getColorResolver(BlockState state) {
        return this.colorResolvers.get(state);
    }
}

